<?php
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

include('link.php'); 

$ids = $_GET['id'] ?? '';

if (!$ids || strpos($ids, '-') === false) {
    die('<span style="color:red;">❌ Invalid or missing ID in URL</span>');
}

list($modelCode, $id) = explode("-", $ids, 2);

switch ($modelCode) {
    case 'sys': $model = 'System'; break;
    case 'lap': $model = 'Laptop'; break;
    case 'prn': $model = 'Printer'; break;
    case 'lan': $model = 'LAN'; break;
    default: $model = 'Unknown'; break;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>NIMI Ticketing System - Configuration</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="background: #6a11cb;">
    <div class="container">
        <center>
            <p class="text-light h3 pt-5 mb-2">NIMI Ticketing System</p>
            <p class="text-light h3 pb-3"><?= htmlspecialchars($model) . ' - ' . htmlspecialchars($id); ?></p>
        </center>

        <div class="row d-flex justify-content-center align-items-center">
            <?php if (!empty($_SESSION['user'])): ?>
                <div class="col-6 col-lg-3 mb-2">
                    <a href="personal.php?id=<?= urlencode($ids); ?>" class="btn btn-success w-100 p-4">Update Configuration</a>
                </div>
            <?php endif; ?>
            <div class="col-6 col-lg-3 mb-2">
                <a href="Systemconfig.php?id=<?= urlencode($ids); ?>" class="btn btn-warning text-dark w-100 p-4">Configuration Info</a>
            </div>
            <div class="col-6 col-lg-3 mb-2">
                <a href="add_complaints.php?id=<?= urlencode($ids); ?>" class="btn btn-danger w-100 p-4">Add Complaints</a>
            </div>
            <div class="col-6 col-lg-3 mb-2">
                <a href="complaint_list.php?id=<?= urlencode($ids); ?>" class="btn btn-light w-100 p-4">View Complaints</a>
            </div>
        </div>
    </div>
</body>
</html>
