<?php
session_start();
if (!isset($_SESSION['user'])) {
    $_SESSION['user'] = 'admin';  
}

$action1 = $_POST['action1'] ?? '';
$module = $_POST['module'] ?? '';
$id = $_POST['id'] ?? '';

if($action1 == 'Submit'){
    if($module == 'System'){
        $module = 'sys';
    } elseif($module == 'Laptop'){
        $module = 'lap';
    } elseif($module == 'Printer'){
        $module ='prn';
    } elseif($module == 'LAN') {
        $module = 'lan';
    } else {
        $module = 'unknown';
    }

    $ids = $module . "-" . $id;
    header("Location: Listconfig.php?id=" . urlencode($ids));
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>NIMI Ticketing System</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Optional Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="background: #6a11cb;">
    <div class="container">
        <center><p class="text-light h3 pb-3 pt-5 mb-2">NIMI Ticketing System</p></center>
        <?php if (!empty($_SESSION['user'])) { ?>
        <form method="POST">
            <div class="row d-flex justify-content-center align-items-center">
                <div class="col-12 col-md-6">
                    <label class="text-light">Enter Your Module <span class="text-danger">*</span></label>
                    <select class="form-control border border-dark text-dark" name="module" required>
                        <option value=''>Select Your Module</option>
                        <option value='LAN'>LAN</option>
                        <option value='Laptop'>Laptop</option>
                        <option value='Printer'>Printer</option>
                        <option value='System'>System</option>
                    </select>
                </div>
                <div class="col-12 col-md-6">
                    <label class="text-light">Enter Your ID <span class="text-danger">*</span></label>
                    <input type="text" name="id" autocomplete="off" class="form-control border border-dark text-dark h3 id" minlength="1" maxlength="3" placeholder="Please Enter Your ID" required>
                </div>
            </div><br>
            <div class="row">
                <div class="col-md-4 offset-md-4">
                    <center>
                        <input type="submit" name="action1" value="Submit" class="btn btn-success w-100">
                    </center>
                </div>
            </div>
        </form>
        <?php } ?>
    </div>
    <script>
        $(document).ready(function(){
            $('.id').on('keyup', function() {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        });
    </script>
</body>
</html>
