<html>  
<head>  
        <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />  
        <title> jQuery File manager for web </title>  
        <script src="https://ajax.googleapis.com"></script>
<style>  
body {  
  background: pink;  
  font-family: sans-serif;  
}  
h1 { margin: 10px;  
  font-family: arial;  
  font-weight: bold;  
  text-align: center;  
}  
h2 { margin: 10px;  
  font-family: arial;  
  font-weight: bold;  
  text-align: center;  
}  
body {  
    margin: 0;  
  font-size: 12px;  
}  
.browser {  
    width: 300px;  
    height: 200px;  
    border: 1px solid gray;  
  float: left;  
  margin: 20px;  
}  
.browser.selected {  
    border-color: blue;  
}  
.browser-widget li.file,  
.browser-widget li.directory {  
    width: 60px;  
}  
</style>  
<body>  
<h1> Example </h1>  
<h2> File manager for web using jquery </h2>  
<div class="browser"> </div>  
</body>  
<script>  
(function($) {  
  var env = {  
    'foo': {  
      'foo.txt': 'foo.txt content',  
      'bar.txt': 'bar.txt content'  
    },  
    'bar': {  
      'page.html': '<html></html>',  
      'style.css': 'body { overflow: scroll; }',  
      baz: {  
        'foo.txt': 'Hello'  
      }  
    },  
    'baz.txt': 'baz.txt content',  
    'quux.txt': 'quux.txt content',  
    'lorem.svg': 'lorem.svg content',  
    'ipsum.doc': 'ipsum.doc content',  
    'dolor.txt': 'dolor.txt content',  
    'sit.jpg': 'sit.jpg content',  
    'amet.gif': 'amet.gif content'  
  };  
  function get(path) {  
    var current = env;  
    browser.walk(path, function(file) {  
      currentcurrent = current[file];  
    });  
    return current;  
  }  
  function remove(src) {  
    var file = env;  
    browser.walk(src, function(part, last) {  
      var src = file[part];  
      if (last) {  
        delete file[part];  
      }  
      file = src;  
    });  
  }  
  function process(src, dest, remove) {  
    console.log('process ' + src + ' => ' + dest);  
    var file = env;  
    var name;  
    browser.walk(src, function(part, last) {  
      var src = file[part];  
      if (last) {  
        if (remove) {  
          delete file[part];  
        }  
      }  
      file = src;  
    });  
    var current = env;  
    browser.walk(dest, function(part, last) {  
      if (!last) {  
        currentcurrent = current[part];  
      } else {  
        name = part;  
      }  
    });  
    current[name] = file;  
    var defer = $.Deferred();  
    setTimeout(function() {  
      defer.resolve();  
    }, 1000);  
    return defer.promise();  
  }  
  function upload(file, path) {  
    var current = env;  
    browser.walk(path, function(part) {  
      if (!current[part]) {  
        current[part] = {};   
      }  
      currentcurrent = current[part];  
    });  
    current[file.name] = 'new file ' + file.name;  
    console.log('upload ' + file.name + ' to ' + path + ' directory');  
    return $.when(true); // resolved promise  
  }  
  $('.browser').browse({  
    root: '/',  
    separator: '/',  
    contextmenu: true,  
    name: 'filestystem',  
    menu: function(type) {  
      if (type == 'li') {  
        return {  
          'play': function($li) {  
            alert('winamp play "' + $li.text() + '"');  
          },  
          'add to playlist': function($li) {  
            alert('playlist "' + $li.text() + '"');  
          }  
        }  
      }  
    },  
    remove: function(src) {  
      remove(src);  
    },  
    rename: function(src, dest) {  
      return process(src, dest, true);  
    },  
    refresh_timer: 0,  
    copy: process,  
    dir: function(path) {  
      dir = get(path);  
      var result;  
      if ($.isPlainObject(dir)) {  
        result = {files:[], dirs: []};  
        Object.keys(dir).forEach(function(key) {  
          if (typeof dir[key] == 'string') {  
            result.files.push(key);  
          } else if ($.isPlainObject(dir[key])) {  
            result.dirs.push(key);  
          }  
        });  
      }  
      return $.when(result); // resolved promise  
    },  
    upload: function(file, path) {  
      return upload(file, path);  
    },  
    open: function(filename) {  
      var file = get(filename);  
      if (typeof file == 'string') {  
        alert(file);  
      }  
    }  
  });  
  var browser = $('.browser').eq(0).browse();  
})(jQuery);  
  
github('jcubic/jquery.filebrowser');  
(function($) {  
  var env = {  
    'foo': {  
      'foo.txt': 'foo.txt content',  
      'bar.txt': 'bar.txt content'  
    },  
    'bar': {  
      'page.html': '<html></html>',  
      'style.css': 'body { overflow: scroll; }',  
      baz: {  
        'foo.txt': 'Hello'  
      }  
    },  
    'baz.txt': 'baz.txt content',  
    'quux.txt': 'quux.txt content',  
    'lorem.svg': 'lorem.svg content',  
    'ipsum.doc': 'ipsum.doc content',  
    'dolor.txt': 'dolor.txt content',  
    'sit.jpg': 'sit.jpg content',  
    'amet.gif': 'amet.gif content'  
  };  
  function get(path) {  
    var current = env;  
    browser.walk(path, function(file) {  
      currentcurrent = current[file];  
    });  
    return current;  
  }  
  function remove(src) {  
    var file = env;  
    browser.walk(src, function(part, last) {  
      var src = file[part];  
      if (last) {  
        delete file[part];  
      }  
      file = src;  
    });  
  }  
  function process(src, dest, remove) {  
    console.log('process ' + src + ' => ' + dest);  
    var file = env;  
    var name;  
    browser.walk(src, function(part, last) {  
      var src = file[part];  
      if (last) {  
        if (remove) {  
          delete file[part];  
        }  
      }  
      file = src;  
    });  
    var current = env;  
    browser.walk(dest, function(part, last) {  
      if (!last) {  
        currentcurrent = current[part];  
      } else {  
        name = part;  
      }  
    });  
    current[name] = file;  
    var defer = $.Deferred();  
    setTimeout(function() {  
      defer.resolve();  
    }, 1000);  
    return defer.promise();  
  }  
  function upload(file, path) {  
    var current = env;  
    browser.walk(path, function(part) {  
      if (!current[part]) {  
        current[part] = {};   
      }  
      currentcurrent = current[part];  
    });  
    current[file.name] = 'new file ' + file.name;  
    console.log('upload ' + file.name + ' to ' + path + ' directory');  
    return $.when(true);   
  }  
  $('.browser').browse({  
    root: '/',  
    separator: '/',  
    contextmenu: true,  
    name: 'filestystem',  
    menu: function(type) {  
      if (type == 'li') {  
        return {  
          'play': function($li) {  
            alert('winamp play "' + $li.text() + '"');  
          },  
          'add to playlist': function($li) {  
            alert('playlist "' + $li.text() + '"');  
          }  
        }  
      }  
    },  
    remove: function(src) {  
      remove(src);  
    },  
    rename: function(src, dest) {  
      return process(src, dest, true);  
    },  
    refresh_timer: 0,  
    copy: process,  
    dir: function(path) {  
      dir = get(path);  
      var result;  
      if ($.isPlainObject(dir)) {  
        result = {files:[], dirs: []};  
        Object.keys(dir).forEach(function(key) {  
          if (typeof dir[key] == 'string') {  
            result.files.push(key);  
          } else if ($.isPlainObject(dir[key])) {  
            result.dirs.push(key);  
          }  
        });  
      }  
      return $.when(result);   
    },  
    upload: function(file, path) {  
      return upload(file, path);  
    },  
    open: function(filename) {  
      var file = get(filename);  
      if (typeof file == 'string') {  
        alert(file);  
      }  
    }  
  });  
  var browser = $('.browser').eq(0).browse();  
})(jQuery);  
</script>  
</body>  
</html>  